<?php
namespace MajorMedia\Project\Models;

use Model;
use MajorMedia\Project\Models\Quote;
use MajorMedia\Project\Models\ProjectType;
use October\Rain\Database\Traits\Validation;

/**
 * Model
 */
class FrontDesign extends Model
{
    use Validation;

    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_project_front_designs';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = [
        'id',
        'name'
    ];
    protected $visible = [
        'id',
        'name'
    ];

    public $hasMany = [
        'quotes' => [
            Quote::class
        ],
    ];
    public $belongsToMany = [
        'project_types' => [
            ProjectType::class,
            'pivotModel' => ProjectTypeDesign::class,
            'table' => 'majormedia_project_type_designs',
            'key' => 'front_design_id',
            'otherKey' => 'project_type_id',
            'pivot' => ['initial_price']
        ]
    ];

}
