<?php
namespace MajorMedia\Project\Models;

use Model;
use October\Rain\Database\Traits\Validation;
/**
 * Model
 */
class ProjectType extends Model
{
    use Validation;

    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_project_project_types';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = [
        'name',
        'environment',
    ];
    protected $visible = [
        'id',
        'name',
        'environment',
        'pivot'
    ];
    public $belongsToMany = [
        'front_designs' => [
            FrontDesign::class,
            'pivotModel' => ProjectTypeDesign::class,
            'table' => 'majormedia_project_type_designs',
            'key' => 'project_type_id',
            'otherKey' => 'front_design_id',
            'pivot' => ['initial_price'],
        ]
    ];

}
