<?php
namespace MajorMedia\Project\Models;

use Model;

/**
 * Model
 */
class SocialPlatform extends Model
{
    use \October\Rain\Database\Traits\Validation;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_project_social_platforms';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];
    protected $fillable = [
        'name',
    ];
    protected $visible = [
        'id',
        'name',
        'pivot'
    ];
    public $belongsToMany = [
        'project' => [
            Project::class,
            'table' => 'project_social_links',
            'key' => 'social_id',
            'otherKey' => 'project_id',
            'pivot' => ['url'],
        ],
    ];



}
