<?php

use Majormedia\Project\Http\PaymentMethods;
use Majormedia\Project\Http\Projects;
use Majormedia\Project\Http\ProjectTypes;
use Majormedia\Project\Http\Quotes;
use Majormedia\Project\Http\ShippingParameters;
use Majormedia\Project\Http\SocialPlatforms;

Route::group([
  'prefix' => 'getApi/v1/endpoint'
], function () {
  Route::resource('projects', Projects::class);

  Route::put('projects-files', Projects::class . '@updateFilesProject');

  Route::prefix('files')->group(function () {
    Route::get('ecommerce', Projects::class . '@ecommerceFiles');
    Route::get('legal', Projects::class . '@legalFiles');
  });

  Route::resource('social-platforms', SocialPlatforms::class);

  Route::resource('project-types', ProjectTypes::class);

  Route::resource('payment-methods', PaymentMethods::class);

  Route::resource('shipping-parameters', ShippingParameters::class);
});