<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * Add notes field to quotes table
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::table('majormedia_project_quotes', function (Blueprint $table) {
            $table->text('notes')->nullable()->after('quote_date');
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::table('majormedia_project_quotes', function (Blueprint $table) {
            $table->dropColumn('notes');
        });
    }
};
