<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateProjectTable Migration
 *
 * @link https://docs.octobercms.com/3.x/extend/database/structure.html
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::create('majormedia_project_projects', function (Blueprint $table) {

            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id')->nullable()->index('fk_user_id');
            $table->unsignedBigInteger('type_id')->nullable()->index('fk_type_id');
            $table->integer('country_id')->unsigned()->nullable()->index('fk_country_id');
            $table->string('country_name')->nullable()->index('index_country_name');

            $table->string('name')->nullable()->index('index_name');
            $table->string('domain')->nullable()->index('index_domain');
            $table->string('address', 512)->nullable()->index('index_address');
            $table->string('email')->nullable()->index('index_email');
            $table->string('phone')->nullable()->index('index_phone');
            $table->string('working_hour')->nullable()->index('index_working_hour');
            $table->smallInteger('status')->default(1)->index('index_status');

            $table->boolean('is_multi_lang')->default(0)->index('index_is_multi_lang');
            $table->boolean('is_logo_required')->default(0)->index('index_is_logo_required');
            $table->boolean('is_content_required')->default(0)->index('index_is_content_required');
            $table->json('languages')->nullable();


            //e-commerce field only
            $table->integer('nbr_products')->nullable()->index('index_nbr_products');
            $table->integer('nbr_categories')->nullable()->index('index_nbr_categories');
            $table->integer('nbr_brands')->nullable()->index('index_nbr_brands');
            $table->smallInteger('sales_method')->default(1)->nullable()->index('index_sales_method');
            $table->string('carrier')->nullable();
            $table->smallInteger('delivery_method')->default(1)->nullable()->index('index_delivery_method');
            $table->smallInteger('shipping_cost_type')->default(1)->nullable()->index('index_shipping_cost_type');


            $table->foreign('user_id', 'fk_projects_user_id')->references('id')->on('users')->onDelete('set null')->onUpdate('cascade');
            $table->foreign('type_id', 'fk_projects_type_id')->references('id')->on('majormedia_project_project_types')->onDelete('set null')->onUpdate('cascade');
            $table->foreign('country_id', 'fk_projects_country_id')->references('id')->on('majormedia_toolbox_countries')->onDelete('set null')->onUpdate('cascade');

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::dropIfExists('majormedia_project_projects');
    }
};
