<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateProjectSocialTable Migration
 *
 * @link https://docs.octobercms.com/3.x/extend/database/structure.html
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::create('majormedia_project_social_links', function (Blueprint $table) {

            $table->bigIncrements('id');

            $table->unsignedBigInteger('project_id')->nullable()->index('fk_project_id');
            $table->unsignedBigInteger('social_id')->nullable()->index('fk_social_id');

            $table->string('url')->nullable()->index('index_url');

            $table->foreign('project_id', 'fk_projects_social_project_id')->references('id')->on('majormedia_project_projects')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('social_id', 'fk_projects_social_social_id')->references('id')->on('majormedia_project_social_platforms')->onDelete('cascade')->onUpdate('cascade');

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::dropIfExists('majormedia_project_social_links');
    }
};
