<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * Update decimal precision for quote amounts
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::table('majormedia_project_quotes', function (Blueprint $table) {
            // Change decimal(9,6) to decimal(10,2) to support larger amounts
            // This allows values up to 99,999,999.99
            $table->decimal('recomanded_amount', 10, 2)->nullable()->change();
            $table->decimal('final_amount', 10, 2)->nullable()->change();
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::table('majormedia_project_quotes', function (Blueprint $table) {
            // Revert to original decimal(9,6)
            $table->decimal('recomanded_amount', 9, 6)->nullable()->change();
            $table->decimal('final_amount', 9, 6)->nullable()->change();
        });
    }
};
