<?php
namespace MajorMedia\Structure\Models;

use Model;
use MajorMedia\Project\Models\ProjectType;
use MajorMedia\Project\Models\Project;
use October\Rain\Database\Traits\Validation;
use MajorMedia\ToolBox\Traits\RetrieveUser;
use Illuminate\Support\Facades\Session;
/**
 * Model
 */
class Feature extends Model
{
    use Validation, RetrieveUser;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_features';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $appends = ['isEnabled'];
    protected $fillable = [
        'project_id',
        'title',
        'description',
        'price',
        'pivot'
    ];
    protected $visible = [
        'id',
        'title',
        'description',
        'price',
        'isEnabled',
    ];

    public $belongsTo = [
        'project' => [Project::class]
    ];
    public $belongsToMany = [
        'project_types' => [
            ProjectType::class,
            'table' => 'majormedia_structure_project_types_features',
            'key' => 'feature_id',
            'otherKey' => 'project_type_id',
            'pivot' => ['is_required', 'is_primary']
        ],
        'projects' => [
            Project::class,
            'table' => 'majormedia_structure_project_features',
            'key' => 'feature_id',
            'otherKey' => 'project_id',
            'pivot' => ['is_required', 'is_primary']
        ]
    ];

    public function getIsEnabledAttribute()
    {
        if (Session::get('required_token') == true) {
            $this->retrieveUser();

            if ($this->user && $this->user->project) {
                return $this->projects()->where('project_id', $this->user->project->id)->exists() ? 1 : 0;
            }
        }
        return null;
    }

}
