<?php
namespace MajorMedia\Structure\Models;

use Model;
use October\Rain\Database\Pivot;
use System\Models\File;
use MajorMedia\Structure\Models\Page;
use MajorMedia\Project\Models\Project;
use MajorMedia\Structure\Models\Field;
use MajorMedia\Structure\Models\Section;
use October\Rain\Database\Traits\Validation;
/**
 * Model
 */
class SiteMap extends Model
{
    use Validation;
    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_sitemaps';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = [
        'project_id',
        'page_id',
        'section_id',
        'field_id',
        'content',
    ];
    protected $visible = [
        'project_id',
        'page',
        'section',
        'field',
        'content'
    ];
    public $belongsToMany = [
        'fields' => [
            Field::class,
            'table' => 'majormedia_structure_sitemaps',
            'key' => 'sitemap_id',
            'otherKey' => 'field_id',
            'pivot' => ['content']
        ],
        'sections' => [
            Section::class,
            'table' => 'majormedia_structure_sitemaps',
            'key' => 'sitemap_id',
            'otherKey' => 'section_id'
        ]
    ];

    public $belongsTo = [
        'project' => [Project::class],
        'page' => [Page::class],
        'section' => [Section::class],
        'field' => [Field::class],
    ];

    //instead of attachMany ,we can use attachOne to to get document product ,document,document images
    //we we register this contnet the client need to send imagecontent:bool ,documentproduct:bool,regularDocument:bool
    //and based on this we can use the proper relation to store this

}
