<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructurePages extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_pages', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('category_id')->nullable()->index('fk_category_id');
            $table->string('name')->nullable()->unique('unique_name');
            $table->boolean('is_legal')->default(0)->index('index_is_legal');
            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
            
            $table->foreign('category_id', 'fk_pages_category_id')->references('id')->on('majormedia_structure_page_categories')->onDelete('set null')->onUpdate('cascade');
        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_pages');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
