<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructureProjectFeatures extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_project_features', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('project_id')->index('fk_project_id');
            $table->unsignedBigInteger('feature_id')->index('fk_feature_id');
            $table->boolean('is_required')->default(0)->index('fk_is_required');
            $table->boolean('is_primary')->default(0)->index('fk_is_primary');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

            $table->foreign('project_id', 'fk_feature_project_id')->references('id')->on('majormedia_project_projects')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('feature_id', 'fk_project_feature_id')->references('id')->on('majormedia_structure_features')->onDelete('CASCADE')->onUpdate('CASCADE');

        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_project_features');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}