<?php namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructureSectionFields extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_section_fields', function($table)
        {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');  
            $table->unsignedBigInteger('section_id')->index('fk_section_id');
            $table->unsignedBigInteger('field_id')->index('fk_field_id');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
            
            $table->foreign('section_id', 'fk_field_section_id')->references('id')->on('majormedia_structure_sections')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('field_id', 'fk_section_field_id')->references('id')->on('majormedia_structure_fields')->onDelete('CASCADE')->onUpdate('CASCADE');
    
        });
    }
    
    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_section_fields');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}