<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructureSitemaps extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_sitemaps', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('project_id')->index('fk_project_id');
            $table->unsignedBigInteger('page_id')->index('fk_page_id');
            $table->unsignedBigInteger('section_id')->nullable()->index('fk_section_id');
            $table->unsignedBigInteger('field_id')->nullable()->index('fk_field_id');
            $table->longText('content')->nullable();
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

            $table->foreign('project_id', 'fk_sitemap_project_id')->references('id')->on('majormedia_project_projects')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('page_id', 'fk_sitemap_page_id')->references('id')->on('majormedia_structure_pages')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('section_id', 'fk_sitemap_section_id')->references('id')->on('majormedia_structure_sections')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('field_id', 'fk_sitemap_field_id')->references('id')->on('majormedia_structure_fields')->onDelete('CASCADE')->onUpdate('CASCADE');

        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_sitemaps');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}