<?php
namespace Majormedia\Structure\Updates;

use DB;
use Seeder;
use MajorMedia\Structure\Models\Page;
use MajorMedia\Structure\Models\Section;

/**
 * CreateSectionsSeeder Seeder
 *
 * Seeds predefined sections into the database.
 */
class CreateSectionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $sections = [
            // ==========================================
            // SECTIONS GÉNÉRALES (pour tous les types)
            // ==========================================
            // Héro: titre (50-100) + sous-titre (100-200) + CTA (20-50) = 170-350 chars
            ['name' => 'Héro', 'project_id' => null, 'char_from' => 150, 'char_to' => 400],
            // À propos: paragraphe descriptif de l'entreprise
            ['name' => 'À propos', 'project_id' => null, 'char_from' => 300, 'char_to' => 800],
            // Services: titre + 3-6 services avec descriptions courtes
            ['name' => 'Services', 'project_id' => null, 'char_from' => 400, 'char_to' => 1200],
            // Produits: titre section + descriptions courtes produits
            ['name' => 'Produits', 'project_id' => null, 'char_from' => 200, 'char_to' => 600],
            // Témoignages: 2-4 avis clients (100-200 chars chacun)
            ['name' => 'Témoignages', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Partenaires: titre + noms/alt des logos
            ['name' => 'Partenaires (logos)', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Articles: titre section + extraits d'articles
            ['name' => 'Articles', 'project_id' => null, 'char_from' => 300, 'char_to' => 900],
            // Demande de devis: titre + description + labels formulaire
            ['name' => 'Demande de devis', 'project_id' => null, 'char_from' => 150, 'char_to' => 400],
            // Newsletter: titre + description + placeholder email
            ['name' => 'Newsletter', 'project_id' => null, 'char_from' => 80, 'char_to' => 250],
            // Pied de page: liens + adresse + copyright + réseaux sociaux
            ['name' => 'Pied de page', 'project_id' => null, 'char_from' => 300, 'char_to' => 800],
            // Introduction: paragraphe d'introduction court
            ['name' => 'Introduction', 'project_id' => null, 'char_from' => 150, 'char_to' => 500],
            // Histoire: récit détaillé de l'entreprise
            ['name' => "Histoire de l'entreprise", 'project_id' => null, 'char_from' => 500, 'char_to' => 1500],
            // Mission et vision: 2 paragraphes
            ['name' => 'Mission et vision', 'project_id' => null, 'char_from' => 200, 'char_to' => 600],
            // Valeurs: 3-5 valeurs avec descriptions
            ['name' => 'Valeurs fondamentales', 'project_id' => null, 'char_from' => 200, 'char_to' => 700],
            // Équipe: noms + titres + bios courtes (4-8 membres)
            ['name' => "Présentation de l'équipe", 'project_id' => null, 'char_from' => 300, 'char_to' => 1200],
            // Chronologie: dates + événements clés
            ['name' => 'Chronologie ou jalons importants', 'project_id' => null, 'char_from' => 300, 'char_to' => 1000],
            // FAQ: 5-10 questions/réponses
            ['name' => 'Foire aux questions', 'project_id' => null, 'char_from' => 500, 'char_to' => 2000],
            // Réassurance: 3-5 éléments courts (livraison, paiement, etc.)
            ['name' => 'Réassurance', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],

            // ==========================================
            // SECTIONS E-COMMERCE
            // ==========================================
            // Nouveautés: titre + noms produits
            ['name' => 'Nouveautés', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Produits en vedette: titre + descriptions courtes
            ['name' => 'Produits en vedette', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Bannière: titre accrocheur + CTA
            ['name' => 'Bannière', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Produits en promotion: titre + prix
            ['name' => 'Produits en promotion', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Meilleures ventes: titre + noms produits
            ['name' => 'Meilleures ventes', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Méga menu: catégories + sous-catégories
            ['name' => 'Méga menu', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Bannière promo: texte promotionnel
            ['name' => 'Bannière de promotion pour les produits en réduction', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Bannières produit/catégorie/marque: titre + CTA
            ['name' => 'Bannière de produit', 'project_id' => null, 'char_from' => 30, 'char_to' => 150],
            ['name' => 'Bannière de catégorie', 'project_id' => null, 'char_from' => 30, 'char_to' => 150],
            ['name' => 'Bannière de marque', 'project_id' => null, 'char_from' => 30, 'char_to' => 150],
            ['name' => 'Bannières doubles', 'project_id' => null, 'char_from' => 60, 'char_to' => 300],
            // Marques populaires: noms de marques
            ['name' => 'Marques populaires', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Partenaires slider: similaire logos
            ['name' => 'Partenaires slider ( logo )', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Flux Instagram: légendes des posts
            ['name' => 'Flux Instagram', 'project_id' => null, 'char_from' => 100, 'char_to' => 500],
            // WhatsApp: numéro + message d'accueil
            ['name' => 'Contact via WhatsApp', 'project_id' => null, 'char_from' => 50, 'char_to' => 150],
            // Filtres: labels des filtres
            ['name' => 'Filtres', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            ['name' => 'Filtres personnalisés', 'project_id' => null, 'char_from' => 150, 'char_to' => 500],
            // Bannière publicitaire: texte pub
            ['name' => 'Bannière publicitaire', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Liste produits: titre section
            ['name' => 'Liste / grille de produits', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Détail produit: description complète + caractéristiques
            ['name' => 'Détail du produit', 'project_id' => null, 'char_from' => 300, 'char_to' => 2000],
            // Produits similaires/associés/populaires: titres
            ['name' => 'Produits similaires', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Produits associés', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            ['name' => 'Produits populaires', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Commentaires: avis clients détaillés
            ['name' => 'Commentaires et avis', 'project_id' => null, 'char_from' => 200, 'char_to' => 1500],
            // Produits consultés: titre
            ['name' => 'Produits récemment consultés', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Partage réseaux sociaux: labels boutons
            ['name' => 'Boutons de partage sur les réseaux sociaux', 'project_id' => null, 'char_from' => 20, 'char_to' => 80],
            // Infos produit: référence, SKU, etc.
            ['name' => "Autres informations (Référence - SKU - Nom de la catégorie - Nom de la marque)", 'project_id' => null, 'char_from' => 50, 'char_to' => 250],
            // Logos paiement: alt text
            ['name' => "Logos de paiement", 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Produits recommandés: titre
            ['name' => 'Produits recommandés', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Partager panier: texte + lien
            ['name' => 'Partager le panier', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Limite quantité: message
            ['name' => 'Limite de quantité', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Panier total: labels
            ['name' => 'panier total prix contrôleur', 'project_id' => null, 'char_from' => 50, 'char_to' => 150],
            // Ajout temps réel: notification
            ['name' => "Ajout en temps réel par d'autres utilisateurs (comme Shopify)", 'project_id' => null, 'char_from' => 50, 'char_to' => 150],
            // Emballage cadeau: options + texte
            ['name' => "Texte personnalisé, Emballage cadeau", 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Infos perso: labels formulaire
            ['name' => "Informations personnalisées", 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Méthodes paiement: noms + descriptions
            ['name' => "Méthodes de paiement", 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Catégories produits: noms catégories
            ['name' => 'Catégories de produits', 'project_id' => null, 'char_from' => 100, 'char_to' => 500],
            // Recherche: placeholder + suggestions
            ['name' => 'Recherche de produits', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Comparaison: labels colonnes
            ['name' => 'Comparaison de produits', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Guide tailles: tableau complet
            ['name' => 'Guide des tailles', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Suivi commande: statuts + messages
            ['name' => 'Suivi de commande', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Historique commandes: labels tableau
            ['name' => 'Historique des commandes', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Adresses livraison: labels formulaire
            ['name' => 'Adresses de livraison', 'project_id' => null, 'char_from' => 100, 'char_to' => 350],
            // Liste souhaits: titre + actions
            ['name' => 'Liste de souhaits', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Points fidélité: explication programme
            ['name' => 'Points de fidélité', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Code promo: champ + message
            ['name' => 'Code promo', 'project_id' => null, 'char_from' => 50, 'char_to' => 150],
            // Estimation livraison: texte explicatif
            ['name' => 'Estimation des frais de livraison', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Options livraison: noms + descriptions
            ['name' => 'Options de livraison', 'project_id' => null, 'char_from' => 150, 'char_to' => 500],
            // Ventes flash: titre + timer
            ['name' => 'Ventes flash', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Countdown: texte urgence
            ['name' => 'Compte à rebours promotion', 'project_id' => null, 'char_from' => 30, 'char_to' => 120],

            // ==========================================
            // SECTIONS VITRINE / CORPORATE
            // ==========================================
            // Réalisations: titre + descriptions projets
            ['name' => 'Nos réalisations', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Galeries: titres + légendes
            ['name' => 'Galerie photos', 'project_id' => null, 'char_from' => 50, 'char_to' => 300],
            ['name' => 'Galerie vidéos', 'project_id' => null, 'char_from' => 50, 'char_to' => 300],
            // Nos clients: noms + secteurs
            ['name' => 'Nos clients', 'project_id' => null, 'char_from' => 50, 'char_to' => 250],
            // Chiffres clés: 4-6 statistiques avec labels
            ['name' => 'Chiffres clés', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Processus: étapes détaillées
            ['name' => 'Processus de travail', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Tarifs: plans + descriptions
            ['name' => 'Tarifs / Offres', 'project_id' => null, 'char_from' => 300, 'char_to' => 1200],
            // Carte: adresse + instructions
            ['name' => 'Carte / Localisation', 'project_id' => null, 'char_from' => 100, 'char_to' => 350],
            // Formulaire contact: labels + placeholders
            ['name' => 'Formulaire de contact', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Infos contact: adresse + téléphone + email
            ['name' => 'Informations de contact', 'project_id' => null, 'char_from' => 150, 'char_to' => 450],
            // Horaires: jours + heures
            ['name' => 'Horaires d\'ouverture', 'project_id' => null, 'char_from' => 80, 'char_to' => 250],
            // Certifications: noms + descriptions
            ['name' => 'Certifications / Récompenses', 'project_id' => null, 'char_from' => 100, 'char_to' => 500],
            // Téléchargements: noms fichiers + descriptions
            ['name' => 'Téléchargements / Ressources', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Actualités: titres + extraits
            ['name' => 'Actualités', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Événements: dates + descriptions
            ['name' => 'Événements', 'project_id' => null, 'char_from' => 200, 'char_to' => 700],
            // Zones service: liste villes/régions
            ['name' => 'Zones de service', 'project_id' => null, 'char_from' => 100, 'char_to' => 500],
            // Avantages: 4-6 points avec descriptions
            ['name' => 'Avantages / Pourquoi nous choisir', 'project_id' => null, 'char_from' => 200, 'char_to' => 700],
            // CTA: titre + description + bouton
            ['name' => 'Appel à l\'action (CTA)', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Comparatif services: tableau
            ['name' => 'Comparatif de services', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Liens réseaux: labels
            ['name' => 'Liens vers réseaux sociaux', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
            // Détail service: description complète
            ['name' => 'Détail du service', 'project_id' => null, 'char_from' => 300, 'char_to' => 1500],
            // Liste services: noms + descriptions courtes
            ['name' => 'Liste des services', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Détail projet: description complète
            ['name' => 'Détail du projet', 'project_id' => null, 'char_from' => 300, 'char_to' => 1500],
            // Liste projets: titres + extraits
            ['name' => 'Liste des projets', 'project_id' => null, 'char_from' => 150, 'char_to' => 600],
            // Filtres projets: labels
            ['name' => 'Filtres projets', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],

            // ==========================================
            // SECTIONS LANDING PAGE
            // ==========================================
            // Héro vidéo: titre + sous-titre
            ['name' => 'Héro avec vidéo', 'project_id' => null, 'char_from' => 100, 'char_to' => 350],
            // Problème/Solution: description détaillée
            ['name' => 'Problème / Solution', 'project_id' => null, 'char_from' => 300, 'char_to' => 1000],
            // Caractéristiques: liste avec descriptions
            ['name' => 'Caractéristiques / Fonctionnalités', 'project_id' => null, 'char_from' => 300, 'char_to' => 1000],
            // Preuves sociales: logos + chiffres
            ['name' => 'Preuves sociales', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Garanties: liste garanties
            ['name' => 'Garanties', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Offre limitée: description urgente
            ['name' => 'Offre limitée', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Formulaire inscription: labels
            ['name' => 'Formulaire d\'inscription', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Countdown: texte urgence
            ['name' => 'Countdown / Urgence', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Bonus: liste bonus avec descriptions
            ['name' => 'Bonus / Cadeaux', 'project_id' => null, 'char_from' => 150, 'char_to' => 600],
            // Avant/Après: descriptions comparatives
            ['name' => 'Avant / Après', 'project_id' => null, 'char_from' => 150, 'char_to' => 500],
            // Études de cas: résultats détaillés
            ['name' => 'Résultats / Études de cas', 'project_id' => null, 'char_from' => 300, 'char_to' => 1200],
            // Cible: description du public
            ['name' => 'À qui s\'adresse cette offre', 'project_id' => null, 'char_from' => 150, 'char_to' => 500],
            // Bio expert: parcours complet
            ['name' => 'Biographie de l\'expert', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Programme: contenu détaillé formation/offre
            ['name' => 'Programme / Contenu détaillé', 'project_id' => null, 'char_from' => 400, 'char_to' => 1500],
            // Témoignages vidéo: légendes
            ['name' => 'Témoignages vidéo', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // CTA flottant: texte court
            ['name' => 'CTA flottant', 'project_id' => null, 'char_from' => 20, 'char_to' => 80],
            // Pop-up sortie: titre + offre
            ['name' => 'Pop-up d\'intention de sortie', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Barre progression: étapes
            ['name' => 'Barre de progression', 'project_id' => null, 'char_from' => 30, 'char_to' => 120],
            // Chat: message accueil
            ['name' => 'Chat en direct', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],

            // ==========================================
            // SECTIONS BLOG
            // ==========================================
            // Liste articles: titres + extraits
            ['name' => 'Liste des articles', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Article vedette: titre + extrait
            ['name' => 'Article en vedette', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Catégories blog: noms
            ['name' => 'Catégories du blog', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Contenu article: texte complet
            ['name' => 'Contenu de l\'article', 'project_id' => null, 'char_from' => 1500, 'char_to' => 8000],
            // Auteur: nom + bio
            ['name' => 'Auteur de l\'article', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Articles similaires: titres
            ['name' => 'Articles similaires', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Commentaires blog: zone commentaires
            ['name' => 'Commentaires blog', 'project_id' => null, 'char_from' => 100, 'char_to' => 1000],
            // Recherche blog: placeholder
            ['name' => 'Barre de recherche blog', 'project_id' => null, 'char_from' => 20, 'char_to' => 80],
            // Tags: liste mots-clés
            ['name' => 'Tags / Mots-clés', 'project_id' => null, 'char_from' => 50, 'char_to' => 250],
            // Archives: dates
            ['name' => 'Archives', 'project_id' => null, 'char_from' => 50, 'char_to' => 200],
            // Articles récents: titres
            ['name' => 'Articles récents', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],
            // Articles populaires: titres
            ['name' => 'Articles populaires', 'project_id' => null, 'char_from' => 80, 'char_to' => 300],

            // ==========================================
            // SECTIONS RECRUTEMENT
            // ==========================================
            // Offres emploi: titres + résumés
            ['name' => 'Offres d\'emploi', 'project_id' => null, 'char_from' => 200, 'char_to' => 800],
            // Détail offre: description complète
            ['name' => 'Détail de l\'offre', 'project_id' => null, 'char_from' => 500, 'char_to' => 2000],
            // Formulaire candidature: labels
            ['name' => 'Formulaire de candidature', 'project_id' => null, 'char_from' => 100, 'char_to' => 400],
            // Avantages employés: liste avantages
            ['name' => 'Avantages employés', 'project_id' => null, 'char_from' => 200, 'char_to' => 700],
            // Culture entreprise: description détaillée
            ['name' => 'Culture d\'entreprise', 'project_id' => null, 'char_from' => 300, 'char_to' => 1000],
            // Processus recrutement: étapes
            ['name' => 'Processus de recrutement', 'project_id' => null, 'char_from' => 200, 'char_to' => 600],

            // ==========================================
            // SECTIONS LÉGALES
            // ==========================================
            // Contenu textuel: texte juridique complet
            ['name' => 'Contenu textuel', 'project_id' => null, 'char_from' => 2000, 'char_to' => 10000],
            // Table des matières: liste sections
            ['name' => 'Table des matières', 'project_id' => null, 'char_from' => 100, 'char_to' => 500],
            // Dernière MAJ: date + note
            ['name' => 'Dernière mise à jour', 'project_id' => null, 'char_from' => 30, 'char_to' => 100],
        ];

        // Insert the section data into the table
        DB::table('majormedia_structure_sections')->insert($sections);

        // ============================================
        // PAGE-SECTION MAPPINGS BY PROJECT TYPE
        // ============================================
        // project_type_id: 1 = E-commerce, 2 = Vitrine, 3 = Landing Page
        // is_repeater: 1 = section avec contenu répétable (bouton +), 0 = section unique

        $pagesToSections = [
            // ================================================
            // PAGE: ACCUEIL
            // ================================================
            'Accueil' => [
                // ----------------------
                // E-COMMERCE (project_type_id = 1)
                // ----------------------
                // Primary sections
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Catégories de produits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2], // Excel import
                ['section' => 'Nouveautés', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3], // Excel import
                ['section' => 'Produits en vedette', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4], // Excel import
                ['section' => 'Bannière', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Produits en promotion', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 6], // Excel import
                ['section' => 'Meilleures ventes', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 7], // Excel import
                ['section' => 'Produits populaires', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8], // Excel import
                ['section' => 'Ventes flash', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 9], // Excel import
                ['section' => 'Témoignages', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 10],
                ['section' => 'Réassurance', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Newsletter', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 12],
                // Secondary sections
                ['section' => 'Méga menu', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 13],
                ['section' => 'Bannière de promotion pour les produits en réduction', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 14],
                ['section' => 'Bannière de produit', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 15],
                ['section' => 'Bannière de catégorie', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 16],
                ['section' => 'Bannière de marque', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 17],
                ['section' => 'Bannières doubles', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 18],
                ['section' => 'Marques populaires', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 19], // Excel import
                ['section' => 'Partenaires slider ( logo )', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 20],
                ['section' => 'Flux Instagram', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 21],
                ['section' => 'Contact via WhatsApp', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 22],
                ['section' => 'Compte à rebours promotion', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 23],
                ['section' => 'Articles', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 24],

                // ----------------------
                // VITRINE (project_type_id = 2)
                // ----------------------
                // Primary sections
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'À propos', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Services', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Nos réalisations', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Témoignages', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Chiffres clés', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 8],
                ['section' => 'Articles', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],
                ['section' => 'Newsletter', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 10],
                // Secondary sections
                ['section' => 'Avantages / Pourquoi nous choisir', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Processus de travail', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 12],
                ['section' => 'Nos clients', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 13],
                ['section' => 'Galerie photos', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 14],
                ['section' => 'Certifications / Récompenses', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 15],
                ['section' => 'Événements', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 16],
                ['section' => 'Flux Instagram', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 17],
                ['section' => 'Contact via WhatsApp', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 18],
                ['section' => 'Demande de devis', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 19],

                // ----------------------
                // LANDING PAGE (project_type_id = 3)
                // ----------------------
                // Primary sections
                ['section' => 'Héro', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Problème / Solution', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Caractéristiques / Fonctionnalités', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Témoignages', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Tarifs / Offres', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Foire aux questions', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 7],
                ['section' => 'Formulaire d\'inscription', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 8],
                // Secondary sections
                ['section' => 'Héro avec vidéo', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 9],
                ['section' => 'Preuves sociales', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 10],
                ['section' => 'Garanties', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Offre limitée', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 12],
                ['section' => 'Countdown / Urgence', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 13],
                ['section' => 'Bonus / Cadeaux', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 14],
                ['section' => 'Avant / Après', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 15],
                ['section' => 'Résultats / Études de cas', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 16],
                ['section' => 'À qui s\'adresse cette offre', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 17],
                ['section' => 'Biographie de l\'expert', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 18],
                ['section' => 'Programme / Contenu détaillé', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 19],
                ['section' => 'Témoignages vidéo', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 20],
                ['section' => 'CTA flottant', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 21],
                ['section' => 'Pop-up d\'intention de sortie', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 22],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 23],
                ['section' => 'Chat en direct', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 24],
            ],

            // ================================================
            // PAGE: À PROPOS / A PROPOS
            // ================================================
            'A propos' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => "Histoire de l'entreprise", 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Mission et vision', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Valeurs fondamentales', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
                ['section' => "Présentation de l'équipe", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Chronologie ou jalons importants', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Certifications / Récompenses', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 8],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => "Histoire de l'entreprise", 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Mission et vision', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Valeurs fondamentales', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 5],
                ['section' => "Présentation de l'équipe", 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Chronologie ou jalons importants', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Chiffres clés', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 8],
                ['section' => 'Certifications / Récompenses', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 10],
                ['section' => 'Galerie photos', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Galerie vidéos', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 12],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 13],
            ],

            // ================================================
            // PAGE: SERVICES
            // ================================================
            'Services' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Liste des services', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste des services', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Détail du service', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Processus de travail', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Tarifs / Offres', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Comparatif de services', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7],
                ['section' => 'Témoignages', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 8],
                ['section' => 'Foire aux questions', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 10],
                ['section' => 'Demande de devis', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 11],
            ],

            // ================================================
            // PAGE: PROJETS
            // ================================================
            'Projets' => [
                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Filtres projets', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste des projets', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Détail du projet', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Galerie photos', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Témoignages', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7],
            ],

            // ================================================
            // PAGE: PARTENAIRES
            // ================================================
            'Partenaires' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Marques populaires', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3], // Excel import

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Partenaires (logos)', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Nos clients', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Témoignages', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
            ],

            // ================================================
            // PAGE: FAQ
            // ================================================
            'FAQ' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Foire aux questions', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Formulaire de contact', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Chat en direct', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Foire aux questions', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Formulaire de contact', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],
            ],

            // ================================================
            // PAGE: BLOG
            // ================================================
            'Blog' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Article en vedette', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste des articles', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Catégories du blog', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Barre de recherche blog', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Tags / Mots-clés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Articles populaires', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Newsletter', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
                // Blog article detail sections
                ['section' => 'Contenu de l\'article', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 9],
                ['section' => 'Auteur de l\'article', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 10],
                ['section' => 'Articles similaires', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Commentaires blog', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 12],
                ['section' => 'Boutons de partage sur les réseaux sociaux', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 13],

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Article en vedette', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste des articles', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Catégories du blog', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Barre de recherche blog', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Tags / Mots-clés', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Articles récents', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Archives', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
                ['section' => 'Newsletter', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 9],
                // Blog article detail sections
                ['section' => 'Contenu de l\'article', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 10],
                ['section' => 'Auteur de l\'article', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 11],
                ['section' => 'Articles similaires', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 12],
                ['section' => 'Commentaires blog', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 13],
                ['section' => 'Boutons de partage sur les réseaux sociaux', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 14],
            ],

            // ================================================
            // PAGE: CONTACT
            // ================================================
            'Contact' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Informations de contact', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Formulaire de contact', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Carte / Localisation', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Horaires d\'ouverture', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Liens vers réseaux sociaux', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Chat en direct', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7],
                ['section' => 'Contact via WhatsApp', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],

                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Informations de contact', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Formulaire de contact', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Carte / Localisation', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Horaires d\'ouverture', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Zones de service', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 6],
                ['section' => 'Liens vers réseaux sociaux', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Demande de devis', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
                ['section' => 'Contact via WhatsApp', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 9],

                // LANDING PAGE
                ['section' => 'Informations de contact', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Formulaire de contact', 'project_type_id' => 3, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Chat en direct', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Contact via WhatsApp', 'project_type_id' => 3, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],
            ],

            // ================================================
            // PAGE: NOUS REJOINDRE (RECRUTEMENT)
            // ================================================
            'Nous rejoindre' => [
                // VITRINE
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Culture d\'entreprise', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Avantages employés', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Offres d\'emploi', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 5],
                ['section' => 'Détail de l\'offre', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'Processus de recrutement', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Formulaire de candidature', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
                ['section' => "Présentation de l'équipe", 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],
                ['section' => 'Témoignages', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 10],
            ],

            // ================================================
            // PAGE: BOUTIQUE (SHOP)
            // ================================================
            'Boutique' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Filtres', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste / grille de produits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3], // Excel import
                ['section' => 'Recherche de produits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4],
                ['section' => 'Filtres personnalisés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Bannière publicitaire', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'Comparaison de produits', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7], // Excel import
                ['section' => 'Produits récemment consultés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8], // Excel import

                // VITRINE (optional shop for vitrine)
                ['section' => 'Héro', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Produits', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Appel à l\'action (CTA)', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
            ],

            // ================================================
            // PAGE: FICHE DE PRODUIT
            // ================================================
            'Fiche de produit' => [
                // E-COMMERCE
                ['section' => 'Détail du produit', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1], // Excel import
                ['section' => 'Galerie photos', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Commentaires et avis', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Produits similaires', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4], // Excel import
                ['section' => 'Produits associés', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5], // Excel import
                ['section' => 'Produits populaires', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6], // Excel import
                ['section' => 'Réassurance', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 7],
                // Secondary
                ['section' => 'Produits récemment consultés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8], // Excel import
                ['section' => 'Boutons de partage sur les réseaux sociaux', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 9],
                ['section' => "Autres informations (Référence - SKU - Nom de la catégorie - Nom de la marque)", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 10], // Excel import
                ['section' => "Logos de paiement", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 11],
                ['section' => 'Guide des tailles', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 12],
                ['section' => 'Estimation des frais de livraison', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 13],
                ['section' => 'Galerie vidéos', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 14],
            ],

            // ================================================
            // PAGE: CATÉGORIES
            // ================================================
            'Catégories' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Filtres', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Liste / grille de produits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3], // Excel import
                ['section' => 'Bannière de catégorie', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],
                // Secondary
                ['section' => 'Filtres personnalisés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Bannière publicitaire', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'Produits en vedette', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7], // Excel import
            ],

            // ================================================
            // PAGE: COLLECTION
            // ================================================
            'Collection' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Introduction', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Filtres', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Liste / grille de produits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4], // Excel import
                ['section' => 'Bannière', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
            ],

            // ================================================
            // PAGE: PANIER
            // ================================================
            'Panier' => [
                // E-COMMERCE
                ['section' => 'Produits recommandés', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1], // Excel import
                ['section' => 'Réassurance', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Code promo', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Estimation des frais de livraison', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],
                // Secondary
                ['section' => 'Partager le panier', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Limite de quantité', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'panier total prix contrôleur', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7],
                ['section' => "Ajout en temps réel par d'autres utilisateurs (comme Shopify)", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
                ['section' => "Texte personnalisé, Emballage cadeau", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 9],
                ['section' => 'Produits récemment consultés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 10], // Excel import
            ],

            // ================================================
            // PAGE: TUNNEL DE COMMANDE (CHECKOUT)
            // ================================================
            'Tunnel de commande' => [
                // E-COMMERCE
                ['section' => "Informations personnalisées", 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Adresses de livraison', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 2],
                ['section' => 'Options de livraison', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 3],
                ['section' => "Méthodes de paiement", 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Code promo', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Réassurance', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 6],
                ['section' => "Logos de paiement", 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 7],
                ['section' => 'Barre de progression', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 8],
            ],

            // ================================================
            // PAGE: ESPACE CLIENT (MY ACCOUNT)
            // ================================================
            'Espace client' => [
                // E-COMMERCE
                ['section' => "Informations personnalisées", 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Historique des commandes', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Suivi de commande', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Adresses de livraison', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 4],
                ['section' => 'Liste de souhaits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Points de fidélité', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'Produits récemment consultés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7], // Excel import
            ],

            // ================================================
            // PAGE: WISHLIST
            // ================================================
            'Wishlist' => [
                // E-COMMERCE
                ['section' => 'Liste de souhaits', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Produits recommandés', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 2], // Excel import
                ['section' => 'Boutons de partage sur les réseaux sociaux', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 3],
            ],

            // ================================================
            // PAGE: PROMOTIONS
            // ================================================
            'Promotions' => [
                // E-COMMERCE
                ['section' => 'Héro', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Ventes flash', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2], // Excel import
                ['section' => 'Compte à rebours promotion', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 3],
                ['section' => 'Produits en promotion', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 4], // Excel import
                ['section' => 'Filtres', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 0, 'order' => 5],
                ['section' => 'Bannière de promotion pour les produits en réduction', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 6],
                ['section' => 'Code promo', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 7],
            ],

            // ================================================
            // PAGES LÉGALES
            // ================================================
            'Conditions générales de vente' => [
                // E-COMMERCE
                ['section' => 'Table des matières', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 1],
                ['section' => 'Contenu textuel', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Dernière mise à jour', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
            ],

            'Politique de retour' => [
                // E-COMMERCE
                ['section' => 'Table des matières', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 1],
                ['section' => 'Contenu textuel', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Foire aux questions', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 1, 'order' => 3],
                ['section' => 'Formulaire de contact', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 4],
            ],

            'Mentions légales' => [
                // E-COMMERCE
                ['section' => 'Contenu textuel', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Dernière mise à jour', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 2],

                // VITRINE
                ['section' => 'Contenu textuel', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 1],
                ['section' => 'Dernière mise à jour', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 2],
            ],

            'Politique de confidentialité' => [
                // E-COMMERCE
                ['section' => 'Table des matières', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 1],
                ['section' => 'Contenu textuel', 'project_type_id' => 1, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Dernière mise à jour', 'project_type_id' => 1, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],

                // VITRINE
                ['section' => 'Table des matières', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 0, 'is_default' => 1, 'is_repeater' => 1, 'order' => 1],
                ['section' => 'Contenu textuel', 'project_type_id' => 2, 'is_primary' => 1, 'is_required' => 1, 'is_default' => 1, 'is_repeater' => 0, 'order' => 2],
                ['section' => 'Dernière mise à jour', 'project_type_id' => 2, 'is_primary' => 0, 'is_required' => 0, 'is_default' => 0, 'is_repeater' => 0, 'order' => 3],
            ],
        ];

        foreach ($pagesToSections as $pageName => $sections) {
            $page = Page::where('name', $pageName)->first();

            if ($page) {
                foreach ($sections as $sectionData) {
                    $section = Section::where('name', $sectionData['section'])->first();

                    if ($section) {
                        \DB::table('majormedia_structure_page_sections')->insert([
                            'page_id' => $page->id,
                            'section_id' => $section->id,
                            'project_type_id' => $sectionData['project_type_id'],
                            'is_primary' => $sectionData['is_primary'],
                            'is_required' => $sectionData['is_required'],
                            'is_repeater' => $sectionData['is_repeater'],
                            'order' => $sectionData['order'],
                        ]);
                    }
                }
            }
        }
    }
}
