<?php namespace RainLab\Location\Updates;

use October\Rain\Database\Updates\Seeder;
use RainLab\Location\Models\Country;

class SeedGbStates extends Seeder
{
    public function run()
    {
        $country = Country::whereCode('GB')->first();
        if ($country->states()->count() > 0) {
            return;
        }

        $country->states()->createMany([
            ['code' => 'ABE', 'name' => 'Aberdeenshire'],
            ['code' => 'ALY', 'name' => 'Anglesey'],
            ['code' => 'ANG', 'name' => 'Angus'],
            ['code' => 'ARG', 'name' => 'Argyll'],
            ['code' => 'AYR', 'name' => 'Ayrshire'],
            ['code' => 'BAN', 'name' => 'Banffshire'],
            ['code' => 'BED', 'name' => 'Bedfordshire'],
            ['code' => 'BER', 'name' => 'Berkshire'],
            ['code' => 'BWS', 'name' => 'Berwickshire'],
            ['code' => 'BRE', 'name' => 'Brecknockshire'],
            ['code' => 'BUC', 'name' => 'Buckinghamshire'],
            ['code' => 'BUT', 'name' => 'Bute'],
            ['code' => 'CAE', 'name' => 'Caernarfonshire'],
            ['code' => 'CAI', 'name' => 'Caithness'],
            ['code' => 'CAM', 'name' => 'Cambridgeshire'],
            ['code' => 'CAR', 'name' => 'Cardiganshire'],
            ['code' => 'CMS', 'name' => 'Carmarthenshire'],
            ['code' => 'CHE', 'name' => 'Cheshire'],
            ['code' => 'CLA', 'name' => 'Clackmannanshire'],
            ['code' => 'CLE', 'name' => 'Cleveland'],
            ['code' => 'COR', 'name' => 'Cornwall'],
            ['code' => 'CRO', 'name' => 'Cromartyshire'],
            ['code' => 'CBR', 'name' => 'Cumberland'],
            ['code' => 'CUM', 'name' => 'Cumbria'],
            ['code' => 'DEN', 'name' => 'Denbighshire'],
            ['code' => 'DER', 'name' => 'Derbyshire'],
            ['code' => 'DEV', 'name' => 'Devon'],
            ['code' => 'DOR', 'name' => 'Dorset'],
            ['code' => 'DBS', 'name' => 'Dumbartonshire'],
            ['code' => 'DUM', 'name' => 'Dumfriesshire'],
            ['code' => 'DUR', 'name' => 'Durham'],
            ['code' => 'ELO', 'name' => 'East Lothian'],
            ['code' => 'ESS', 'name' => 'Essex'],
            ['code' => 'FLI', 'name' => 'Flintshire'],
            ['code' => 'FIF', 'name' => 'Fife'],
            ['code' => 'GLA', 'name' => 'Glamorgan'],
            ['code' => 'GLO', 'name' => 'Gloucestershire'],
            ['code' => 'HAM', 'name' => 'Hampshire'],
            ['code' => 'HER', 'name' => 'Herefordshire'],
            ['code' => 'HTF', 'name' => 'Hertfordshire'],
            ['code' => 'HUN', 'name' => 'Huntingdonshire'],
            ['code' => 'INV', 'name' => 'Inverness'],
            ['code' => 'KEN', 'name' => 'Kent'],
            ['code' => 'KCD', 'name' => 'Kincardineshire'],
            ['code' => 'KIN', 'name' => 'Kinross-shire'],
            ['code' => 'KIR', 'name' => 'Kirkcudbrightshire'],
            ['code' => 'LKS', 'name' => 'Lanarkshire'],
            ['code' => 'LAN', 'name' => 'Lancashire'],
            ['code' => 'LEI', 'name' => 'Leicestershire'],
            ['code' => 'LIN', 'name' => 'Lincolnshire'],
            ['code' => 'LON', 'name' => 'London'],
            ['code' => 'MAN', 'name' => 'Manchester'],
            ['code' => 'MER', 'name' => 'Merionethshire'],
            ['code' => 'MSY', 'name' => 'Merseyside'],
            ['code' => 'MDX', 'name' => 'Middlesex'],
            ['code' => 'MID', 'name' => 'Midlands'],
            ['code' => 'MLT', 'name' => 'Midlothian'],
            ['code' => 'MON', 'name' => 'Monmouthshire'],
            ['code' => 'MGY', 'name' => 'Montgomeryshire'],
            ['code' => 'MOR', 'name' => 'Moray'],
            ['code' => 'NAI', 'name' => 'Nairnshire'],
            ['code' => 'NOR', 'name' => 'Norfolk'],
            ['code' => 'NMP', 'name' => 'Northamptonshire'],
            ['code' => 'NUM', 'name' => 'Northumberland'],
            ['code' => 'NOT', 'name' => 'Nottinghamshire'],
            ['code' => 'ORK', 'name' => 'Orkney'],
            ['code' => 'OXF', 'name' => 'Oxfordshire'],
            ['code' => 'PEE', 'name' => 'Peebleshire'],
            ['code' => 'PEM', 'name' => 'Pembrokeshire'],
            ['code' => 'PER', 'name' => 'Perthshire'],
            ['code' => 'RAD', 'name' => 'Radnorshire'],
            ['code' => 'REN', 'name' => 'Renfrewshire'],
            ['code' => 'ROS', 'name' => 'Ross & Cromarty'],
            ['code' => 'ROX', 'name' => 'Roxburghshire'],
            ['code' => 'RUT', 'name' => 'Rutland'],
            ['code' => 'SEL', 'name' => 'Selkirkshire'],
            ['code' => 'SHE', 'name' => 'Shetland'],
            ['code' => 'SHR', 'name' => 'Shropshire'],
            ['code' => 'SOM', 'name' => 'Somerset'],
            ['code' => 'STA', 'name' => 'Staffordshire'],
            ['code' => 'STI', 'name' => 'Stirlingshire'],
            ['code' => 'SUF', 'name' => 'Suffolk'],
            ['code' => 'SUR', 'name' => 'Surrey'],
            ['code' => 'SUS', 'name' => 'Sussex'],
            ['code' => 'SUT', 'name' => 'Sutherland'],
            ['code' => 'TYN', 'name' => 'Tyne & Wear'],
            ['code' => 'WAR', 'name' => 'Warwickshire'],
            ['code' => 'WLO', 'name' => 'West Lothian'],
            ['code' => 'WES', 'name' => 'Westmorland'],
            ['code' => 'WIG', 'name' => 'Wigtownshire'],
            ['code' => 'WIL', 'name' => 'Wiltshire'],
            ['code' => 'WOR', 'name' => 'Worcestershire'],
            ['code' => 'YOR', 'name' => 'Yorkshire']
        ]);
    }
}
