# Overview

This page describes the support policy for the Amazon S3 Encryption Client for PHP. We regularly provide the Amazon S3 Encryption Client for PHP with updates that may contain support for new or updated APIs, new features, enhancements, bug fixes, security patches, or documentation updates. Updates may also address changes with dependencies, language runtimes, and operating systems.

We recommend users to stay up-to-date with Amazon S3 Encryption Client for PHP releases to keep up with the latest features, security updates, and underlying dependencies. Continued use of an unsupported SDK version is not recommended and is done at the user's discretion.

# Major Version Lifecycle

The Amazon S3 Encryption Client for Go follows the same major version lifecycle as the AWS SDK. For details on this lifecycle, see [AWS SDKs and Tools Maintenance Policy](https://docs.aws.amazon.com/sdkref/latest/guide/maint-policy.html#version-life-cycle).

# Version Support Matrix

This table describes the current support status of each major version of the Amazon S3 Encryption Client for PHP. It also shows the next status each major version will transition to, and the date at which that transition will happen.

| Major version | Current status | Next status | Next status date |
|--------------|----------------|-------------|------------------|
| 3.x | General Availability | - | - |
| 2.x | General Availability | Maintenance | 2026-06-15 |
| 1.x | End of Support | - | - |
